/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.util;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;

public class Font {
    private static String systemFont;
    private static int systemHeight;
    private static HashMap<String, org.eclipse.swt.graphics.Font> fontCache;
    public static final Font H1;
    public static final Font H2;
    public static final Font H3;
    public static final Font SMALL;
    public static final Font DEFAULT;
    public static final Font BOLD;
    public static final Font ITALIC;
    private String name;
    private FontData value;
    private FontData defaultValue;
    private static Settings settings;

    private Font(String name, FontData defaultValue) {
        if (name == null) {
            throw new NullPointerException("name of color cannot be null");
        }
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public final org.eclipse.swt.graphics.Font getSWTFont() {
        org.eclipse.swt.graphics.Font f;
        if (this.value == null) {
            this.value = settings.getFontData(this.name, this.defaultValue);
        }
        if ((f = fontCache.get(this.value.toString())) != null && !f.isDisposed()) {
            return f;
        }
        f = new org.eclipse.swt.graphics.Font((Device)GUI.getDisplay(), this.value);
        fontCache.put(this.value.toString(), f);
        return f;
    }

    public final void setSWTFont(org.eclipse.swt.graphics.Font newFont) {
        if (newFont == null) {
            return;
        }
        this.value = newFont.getFontData()[0];
        settings.setAttribute(this.name, this.value);
        org.eclipse.swt.graphics.Font f = fontCache.remove(this.value.toString());
        if (f != null && !f.isDisposed()) {
            f.dispose();
        }
    }

    public static int getHeight(Font font) {
        FontData fd = font.getSWTFont().getFontData()[0];
        return SWTUtil.pt2px(fd.getHeight());
    }

    static {
        systemHeight = 10;
        try {
            org.eclipse.swt.graphics.Font sysFont = GUI.getDisplay().getSystemFont();
            FontData fd = sysFont.getFontData()[0];
            Logger.info((String)("system font: " + fd.toString()));
            systemFont = fd.getName();
            systemHeight = fd.getHeight();
        }
        catch (Exception e) {
            Logger.error((String)"unable to find systemn font", (Throwable)e);
        }
        fontCache = new HashMap();
        H1 = new Font("font.h1", new FontData(systemFont, systemHeight + 2, 1));
        H2 = new Font("font.h2", new FontData(systemFont, systemHeight + 1, 1));
        H3 = new Font("font.h3", new FontData(systemFont, systemHeight, 2));
        SMALL = new Font("font.small", new FontData(systemFont, systemHeight - 1, 0));
        DEFAULT = new Font("font.default", new FontData(systemFont, systemHeight, 0));
        BOLD = new Font("font.bold", new FontData(systemFont, systemHeight, 1));
        ITALIC = new Font("font.italic", new FontData(systemFont, systemHeight, 2));
        settings = new Settings(Font.class);
        settings.setStoreWhenRead(false);
    }
}

